<?php

$use_ekkolightbox = true;

include '_init.php';

include '_header.php';

?>

<!-- Main Start -->
<div id="main">
    <!-- Banner -->
    <div class="page-section">
        <div class="header-banner hidden-xs">
            <ul class="banner-transparent">
                <!--
					     <li>
                            <figure><img src="assets/images/slider/slide_slider-2.jpg" alt=""></figure>
                        </li>
						<li>
                            <figure><img src="assets/images/slider/slide_img0049.jpg" alt=""></figure>
                        </li>
						-->

                <?php

                $res = send_sql("SELECT * FROM slider ORDER BY ORDRE");

                while ($ligne = $res->fetch(PDO::FETCH_OBJ)) { ?>
                    <li>
                        <figure><img src="assets/images/slider/slide_<?= $ligne->NOM ?>" alt=""></figure>
                    </li>
                <?php } ?>

            </ul>
        </div>

        <div class="hidden-sm hidden-md hidden-lg hidden-xl">
            <figure>
                <a href="up-and-go.php"><img src="img/fabrique-en-france.jpg" alt="UP AND GO, le système de construction fabriqué en France"></a>
            </figure>

        </div>
        <!-- Banner -->


        <?php include '_bandeau_contact.php'; ?>


        <!-- Intro Section -->
        <div class="page-section pt-90 pb-60 section-bg-8">
            <div class="container">
                <div class="row ">
                    <!-- section heading -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12  mb-40">
                        <div class="section-heading">
                            <span>Une nouvelle génération de constructions</span>
                            <h2>Le bloc coffrant QUICK'UP</h2>
                        </div>
                    </div>
                    <!-- section heading -->
                    <!-- Services View Start -->
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="bu-services-img  mb-30">
                            <div class="img-holder">
                                <figure>
                                    <a href="atouts.php"><img src="assets/images/home-atouts.webp" alt=""></a>
                                </figure>
                            </div>
                            <div class="text-holder">
                                <h4><a href="atouts.php">Les atouts</a></h4>
                                <p>Hautes performances, facilité de pose, gain de temps... découvrez les atouts du bloc coffrant QUICK'UP.</p>
                                <a href="atouts.php" class="bu-color link"><span class="ti-arrow-right"></span></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="bu-services-img  mb-30">
                            <div class="img-holder">
                                <figure>
                                    <a href="gamme.php"><img src="assets/images/home-gamme.jpg" alt=""></a>
                                </figure>
                            </div>
                            <div class="text-holder">
                                <h4><a href="gamme.php">Une gamme complète </a></h4>
                                <p>Réduction des coupes, gain de temps : QUICK’UP propose une gamme complète de modules fabriqués en usine. </p>
                                <a href="gamme.php" class="bu-color link"><span class="ti-arrow-right"></span></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="bu-services-img  mb-30">
                            <div class="img-holder">
                                <figure>
                                    <a href="montage.php"><img src="assets/images/home-construction.jpg" alt=""></a>
                                </figure>
                            </div>
                            <div class="text-holder">
                                <h4><a href="montage.php">Construction</a></h4>
                                <p>QUICK'UP propose 3 formules au choix : auto-construction, accompagnement, ou package Fourniture & Pose.</p>
                                <a href="montage.php" class="bu-color link"><span class="ti-arrow-right"></span></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="bu-services-img  mb-30">
                            <div class="img-holder">
                                <figure>
                                    <a href="up-and-go.php"><img src="assets/images/home-upandgo.jpg" alt=""></a>
                                </figure>
                            </div>
                            <div class="text-holder">
                                <h4><a href="up-and-go.php">Méthode UP AND GO</a></h4>
                                <p>QUICK'UP a breveté la méthode exclusive «UP and GO» pour un montage sûr, facile et rapide.</p>
                                <a href="up-and-go.php" class="bu-color link"><span class="ti-arrow-right"></span></a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- Intro Section -->
        <!-- Split Box Section Start -->
        <div class="parallax-window" data-parallax="scroll" data-image-src="assets/images/bg-plan.jpg">
            <div class="page-section section-bg-7  pt-90 pb-90">
                <div class="container ">
                    <div class="row">

                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">

                            <h2 class="mb-10">QUICK'UP fabricant leader dans le domaine du bloc coffrant.</h2>

                            <p class="mb-20">Avec plus de 15 ans d’expérience et plus de 600 réalisations, QUICK’UP s’engage à devenir le leader
                                du bloc coffrant, grâce à un produit d’exception en maîtrisant les coûts de production, mais
                                également en proposant la pose par nos équipes dédiées.<br />
                                En tant que fabricant et non distributeur, nous sommes soucieux de la qualité de nos produits,
                                des relevés techniques et des tests sont régulièrement approuvés.<br />
                                C’est cette relation directe entre l’industriel et le client final (pas d’intermédiaire) qui permet de
                                minimiser les coûts et ainsi proposer le meilleur produit du marché à un prix compétitif.</p>

                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 mb-15">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="bu-counter-s2">
                                        <div class="text-holder "> <strong class="counter">98.6</strong><b>%</b> <span>Clients satisfaits</span> </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="bu-counter-s2">
                                        <div class="text-holder"> <strong class="counter">642</strong><b><span class="ti-plus"></span></b> <span>Chantiers réalisés</span> </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="bu-counter-s2">
                                        <div class="text-holder"> <strong class="counter">35</strong><b><span class="ti-plus"></span></b> <span>Experts en pose</span> </div>
                                    </div>
                                </div>
                            </div>

                            <a href="doc/quickup-brochure.pdf#page=4" target="_blank" class="bu-button-simple bu-bgcolor button-swipe btn-4 mt-5 mb-10">Plus d'infos ?</a>

                        </div>

                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                            <div class="img-holder defualt">
                                <figure>
                                    <img src="assets/images/bloc-quick.png" alt="">
                                </figure>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Split Box Section Start -->
        <!-- features Section Start -->
        <div class="page-section section-bg-gray1 pt-90 pb-60">
            <div class="container">
                <div class="row">
                    <!-- section heading -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12  mb-40">
                        <div class="section-heading">
                            <span>Pourquoi choisir QUICK'UP</span>
                            <h2>Les atouts du bloc coffrant QUICK'UP</h2>
                        </div>
                    </div>
                    <!-- section heading -->
                    <!-- <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12"> -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <div class="text-holder mb-20 ml-20">
                            <p> Particuliers ou professionnels, optez pour le bloc coffrant isolant QUICK'UP. </p>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
                            <div class="bu-services-box animated-border-btm">
                                <a href="#">
                                    <div class="img-holder">
                                        <figure><span class="ti-medall-alt"></span></figure>
                                    </div>
                                    <div class="text-holder">
                                        <h4>Fabrication française</h4>
                                        <p>Les blocs coffrants isolants sont produits dans notre usine située au centre de la France.</p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
                            <div class="bu-services-box animated-border-btm">
                                <a href="#">
                                    <div class="img-holder">
                                        <figure><span class="ti-cup"></span></figure>
                                    </div>
                                    <div class="text-holder">
                                        <h4>Qualité / Prix</h4>
                                        <p>Le bloc coffrant isolant QUICK'UP offre le meilleur rapport Qualité / Prix du marché.</p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
                            <div class="bu-services-box animated-border-btm">
                                <a href="#">
                                    <div class="img-holder">
                                        <figure><span class="ti-timer"></span></figure>
                                    </div>
                                    <div class="text-holder">
                                        <h4>Gagnez du temps</h4>
                                        <p>Avoc nos blocs coffrants isolants, le temps d'élévation d'une construction est réduit. </p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
                            <div class="bu-services-box animated-border-btm">
                                <a href="#">
                                    <div class="img-holder">
                                        <figure><span class="ti-comments-smiley"></span></figure>
                                    </div>
                                    <div class="text-holder">
                                        <h4>Hotline</h4>
                                        <p>Nous sommes à vos côtés dans votre projet pour vous apporter notre expertise.</p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
                            <div class="bu-services-box animated-border-btm">
                                <a href="#">
                                    <div class="img-holder">
                                        <figure><span class="ti-shield"></span></figure>
                                    </div>
                                    <div class="text-holder">
                                        <h4>Construction robuste</h4>
                                        <p>Le bloc coffrant rempli de béton est de loin le mode de construction le plus solide.</p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
                            <div class="bu-services-box animated-border-btm">
                                <a href="#">
                                    <div class="img-holder">
                                        <figure><span class="ti-thumb-up"></span></figure>
                                    </div>
                                    <div class="text-holder">
                                        <h4>Hautes performances</h4>
                                        <p>Des performances thermiques remarquables, et une excellente isolation phonique. </p>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" style="display: none">
                        <div class="bu-contact-form fancy">
                            <div class="form-holder">
                                <div class="wrap-contact100 qf section-bg-6b">
                                    <form class="contact-form validate-form">
                                        <span class="contact-form-text">
                                            Besoin d'informations ?
                                        </span>
                                        <div class="wrap-input100" data-validate="Name is required">
                                            <span class="label-input100">Votre nom</span>
                                            <input class="input100" name="name" placeholder="Entrez votre nom" type="text">
                                            <span class="focus-input100"></span>
                                        </div>
                                        <div class="wrap-input100" data-validate="Valid email is required: ex@abc.xyz">
                                            <span class="label-input100">Email</span>
                                            <input class="input100" name="email" placeholder="Entrez votre adresse e-mail" type="text">
                                            <span class="focus-input100"></span>
                                        </div>
                                        <div class="wrap-input100" data-validate="Valid email is required: ex@abc.xyz">
                                            <span class="label-input100">Téléphone</span>
                                            <input class="input100" name="email" placeholder="Entrez votre n° de téléphone" type="text">
                                            <span class="focus-input100"></span>
                                        </div>
                                        <div class="wrap-input100 input100-select">
                                            <span class="label-input100">Informations demandées</span>
                                            <div>
                                                <select class="selection-2" name="service">
                                                    <option>Votre choix</option>
                                                    <option>Construction</option>
                                                    <option>Infos techniques</option>
                                                    <option>Nos produits</option>
                                                    <option>Assistance</option>
                                                </select>
                                            </div>
                                            <span class="focus-input100"></span>
                                        </div>
                                        <div class="container-contact-form-btn">
                                            <button class=" bu-button-simple bu-bgcolor button-swipe btn-3">Envoyer</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Feature Section End -->
        <!-- Portfolio Section -->
        <div class="page-section pt-90 pb-60 section-bg-8">
            <div class="container">
                <div class="row">
                    <!-- section heading -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 mb-40">
                        <div class="section-heading">
                            <!--<span>Vos questions</span>-->
                            <h2>Nos actualités</h2>
                        </div>
                    </div>
                    <!-- section heading -->
                    <!-- Portfolio View Start -->
                    <ul class="portfolio-slider">
                        <?php
                        $res = send_sql("SELECT * FROM actu WHERE AFFICHER=1 ORDER BY DATE LIMIT 4");

                        while ($actu = $res->fetch(PDO::FETCH_OBJ)) {

                        ?>
                           <?php if (false) { ?>
                           <li class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                <div class="bu-porfolio-classic">
                                    <div class="img-holder">
                                        <figure>
                                            <a href="fiche-actu.php?id=<?= $actu['ID']?>"><img src="img/actu/mini-<?= $actu['PHOTO'] ?> " alt="Les actualités"></a>
                                        </figure>
                                    </div>
                                    <div class="text-holder pt-20 pb-20">
                                        <span class="category"><?= datefr($actu['DATE']) ?></span>
                                        <h3><a href="#"><?= $actu['TITRE'] ?> </a></h3>
                                        <a href="#" class="bu-color link"><span class="ti-plus"></span></a>
                                    </div>
                                </div>
                            </li>
                            <?php } ?>
                            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                <div class="bu-services-img  mb-30">
                                    
                                    <div class="img-holder">
                                        <span class="category"><?= datefr($actu->DATE) ?></span>
                                        <figure>
                                            <a href="actu-fiche.php?id=<?= $actu->ID?>"><img src="img/actu/mini-<?= $actu->PHOTO ?>" alt="Les actualités"></a>
                                        </figure>
                                    </div>
                                    <div class="text-holder">
                                        <h4><a href="actu-fiche.php?id=<?= $actu->ID?>"><?= $actu->TITRE ?></a></h4>
                                        <p><?=$actu->RESUME?></p>
                                        <a href="actu-fiche.php?id=<?= $actu->ID?>" class="bu-color link"><span class="ti-arrow-right"></span></a>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </ul> 
                    <!-- Portfolio View End -->
                    <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
                        <a href="actus.php" class="bu-button-simple bu-bgcolor button-swipe btn-4 mt-5">Toutes nos actualités</a>
                    </div>

                </div>
            </div>
        </div>
        <div class="page-section pt-90 pb-60 section-bg-8">
            <div class="container">
                <div class="row">
                    <!-- section heading -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 mb-40">
                        <div class="section-heading">
                            <span>10 ans d'expérience </span>
                            <h2>Nos réalisations</h2>
                        </div>
                    </div>
                    <!-- section heading -->
                    <!-- Portfolio View Start -->
                    <ul class="portfolio-slider">
                        <li class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <div class="bu-porfolio-classic">
                                <div class="img-holder">
                                    <figure>
                                        <a href="#"><img src="assets/images/chantier-1.jpg" alt="Les chantiers réalisés par QUICK'UP"></a>
                                    </figure>
                                </div>
                                <div class="text-holder pt-20 pb-20">
                                    <span class="category">Construction</span>
                                    <h3><a href="#">Maison contemporaine </a></h3>
                                    <a href="#" class="bu-color link"><span class="ti-plus"></span></a>
                                </div>
                            </div>
                        </li>
                        <li class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <div class="bu-porfolio-classic">
                                <div class="img-holder">
                                    <figure>
                                        <a href="#"><img src="assets/images/chantier-2.jpg" alt="Les chantiers réalisés par QUICK'UP"></a>
                                    </figure>
                                </div>
                                <div class="text-holder pt-20 pb-20">
                                    <span class="category">Agrandissement</span>
                                    <h3><a href="#">Garage monopente</a></h3>
                                    <a href="#" class="bu-color link"><span class="ti-plus"></span></a>
                                </div>
                            </div>
                        </li>
                        <li class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <div class="bu-porfolio-classic">
                                <div class="img-holder">
                                    <figure>
                                        <a href="#"><img src="assets/images/chantier-3.jpg" alt="Les chantiers réalisés par QUICK'UP"></a>
                                    </figure>
                                </div>
                                <div class="text-holder pt-20 pb-20">
                                    <span class="category">Construction</span>
                                    <h3><a href="#">Pavillon 125 m² </a></h3>
                                    <a href="#" class="bu-color link"><span class="ti-plus"></span></a>
                                </div>
                            </div>
                        </li>
                        <li class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <div class="bu-porfolio-classic">
                                <div class="img-holder">
                                    <figure>
                                        <a href="#"><img src="assets/images/chantier-1.jpg" alt="Les chantiers réalisés par QUICK'UP"></a>
                                    </figure>
                                </div>
                                <div class="text-holder pt-20 pb-20">
                                    <span class="category">Construction</span>
                                    <h3><a href="#">Maison contemporaine </a></h3>
                                    <a href="#" class="bu-color link"><span class="ti-plus"></span></a>
                                </div>
                            </div>
                        </li>
                        <li class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <div class="bu-porfolio-classic">
                                <div class="img-holder">
                                    <figure>
                                        <a href="#"><img src="assets/images/chantier-2.jpg" alt="Les chantiers réalisés par QUICK'UP"></a>
                                    </figure>
                                </div>
                                <div class="text-holder pt-20 pb-20">
                                    <span class="category">Agrandissement</span>
                                    <h3><a href="#">Garage monopente</a></h3>
                                    <a href="#" class="bu-color link"><span class="ti-plus"></span></a>
                                </div>
                            </div>
                        </li>
                        <li class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <div class="bu-porfolio-classic">
                                <div class="img-holder">
                                    <figure>
                                        <a href="#"><img src="assets/images/chantier-3.jpg" alt="Les chantiers réalisés par QUICK'UP"></a>
                                    </figure>
                                </div>
                                <div class="text-holder pt-20 pb-20">
                                    <span class="category">Construction</span>
                                    <h3><a href="#">Pavillon 125 m² </a></h3>
                                    <a href="#" class="bu-color link"><span class="ti-plus"></span></a>
                                </div>
                            </div>
                        </li>
                    </ul>
                    <!-- Portfolio View End -->
                    <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
                        <a href="chantiers.php" class="bu-button-simple bu-bgcolor button-swipe btn-4 mt-5">Toutes nos réalisations</a>
                    </div>

                </div>
            </div>
        </div>
        <!-- Portfolio Section -->

        <!-- Split Box Section Start -->
        <div class="parallax-window" data-parallax="scroll" data-image-src="assets/images/bg-construire.jpg">
            <div class="page-section section-bg-6b pt-120 pb-120">
                <div class="container ">
                    <div class="row">

                        <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
                            <h2 class="mb-10">La construction : 3 formules au choix</h2>
                            <p class="mb-20"> En autonomie avec la hotline, ou bien accompagné d'un technicien, ou encore en optant pour le package Fourniture & Pose... choisissez la formule qui vous convient. </p>

                            <a href="montage.php" class="bu-button-simple bu-bgcolor button-swipe btn-4 mt-5">Voir les formules</a>

                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Split Box Section Start -->

        <!-- Testimonials Section -->

        <div class="page-section pt-90 pb-90">
            <div class="container">
                <div class="row">
                    <!-- section heading -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 mb-40">
                        <div class="section-heading">
                            <span>Ils ont choisi QUICK'UP</span>
                            <h2>Les avis de nos clients</h2>
                        </div>
                    </div>
                    <!-- section heading -->
                    <!-- Testimonials Slider -->
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <ul class="bu-testimonial-slider">
                            <li>
                                <div class="bu-testimonials-v1">
                                    <div class="text-holder">
                                        <p>Avec ma femme nous sommes ravis de la prestation de QUICK'UP. Ils ont su nous séduire de part la prestation de leurs services, alors que d'autres constructeurs n'y sont pas parvenus. L'équipe a été parfaite dans l'accueil, l'écoute et le suivi de notre projet. Merci !</p>
                                        <div class="author-info">
                                            <figure><img src="assets/images/dummy-user.png" alt=""></figure>
                                            <h6> Jean-Luc et Nadia M.</h6>
                                            <span>St Martin le Beau (37)</span>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="bu-testimonials-v1">
                                    <div class="text-holder">
                                        <p>Avec ma femme nous sommes ravis de la prestation de QUICK'UP. Ils ont su nous séduire de part la prestation de leurs services, alors que d'autres constructeurs n'y sont pas parvenus. L'équipe a été parfaite dans l'accueil, l'écoute et le suivi de notre projet. Merci !</p>
                                        <div class="author-info">
                                            <figure><img src="assets/images/dummy-user.png" alt=""></figure>
                                            <h6> Jean-Luc et Nadia M.</h6>
                                            <span>St Martin le Beau (37)</span>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="bu-testimonials-v1">
                                    <div class="text-holder">
                                        <p>Avec ma femme nous sommes ravis de la prestation de QUICK'UP. Ils ont su nous séduire de part la prestation de leurs services, alors que d'autres constructeurs n'y sont pas parvenus. L'équipe a été parfaite dans l'accueil, l'écoute et le suivi de notre projet. Merci !</p>
                                        <div class="author-info">
                                            <figure><img src="assets/images/dummy-user.png" alt=""></figure>
                                            <h6> Jean-Luc et Nadia M.</h6>
                                            <span>St Martin le Beau (37)</span>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <!-- Testimonials Slider -->
                </div>
            </div>

        </div>
        <!-- Testimonials Section -->

        <!--
            <div class="page-section pt-90 pb-90 section-bg-4">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="bu-partners">
                                <div class="text-holder mb-20">
                                    <h4>We work with our clients and partners to <span class="bu-color"> delivered flawless &amp; ontime </span> projects</h4>
                                </div>

                                <ul class="logo-transparent">
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="partner logo"></a>
                                        </figure>
                                    </li>
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="partner logo"></a>
                                        </figure>
                                    </li>
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="client logo"></a>
                                        </figure>
                                    </li>
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="partner logo"></a>
                                        </figure>
                                    </li>
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="partner logo"></a>
                                        </figure>
                                    </li>
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="partner logo"></a>
                                        </figure>
                                    </li>
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="partner logo"></a>
                                        </figure>
                                    </li>
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="partner logo"></a>
                                        </figure>
                                    </li>
                                    <li class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                        <figure>
                                            <a href="#"><img src="assets/images/182x90.png" alt="partner logo"></a>
                                        </figure>
                                    </li>
                                </ul>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
				
				-->

        <?php if (false) { ?>
            <!-- Section FAQ's and News Start -->
            <div class="page-section pt-90 pb-90 section-bg-2">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="row">

                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

                                    <div class="img-holder">
                                        <figure>
                                            <img src="assets/images/390x550.jpg" alt="">
                                        </figure>
                                    </div>

                                </div>

                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="row">
                                <!-- section heading -->
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 mb-40">
                                    <div class="section-heading">
                                        <h3>Customer FAQ’s</h3>
                                    </div>
                                </div>
                                <!-- section heading -->
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                    <div class="bu-text">
                                        <p>Here are some of the most frequently asked questions, as well as answers, so you can easily find desire answer </p>
                                    </div>
                                    <div class="faq-area">
                                        <div class="faq panel-group " id="faq_2848769">
                                            <div class="panel">
                                                <div class="panel-heading">
                                                    <strong class="panel-title">
                                                        <a class="collapsed" data-toggle="collapse" data-parent="#faq_2848769" href="#collapse1" aria-expanded="false">How to Contact for Services </a>
                                                    </strong>
                                                </div>
                                                <div id="collapse1" class="panel-collapse collapse in" aria-expanded="false" role="button">
                                                    <div class="panel-body no-border">
                                                        <p>People always have questions about company detail services. Hopefully these questions and answers have provided you with all of the services information you need to decide.</p>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="panel">
                                                <div class="panel-heading">
                                                    <strong class="panel-title">
                                                        <a class="collapsed" data-toggle="collapse" data-parent="#faq_2848769" href="#collapse2" aria-expanded="false">How Honesty is Always the Best Policy </a>
                                                    </strong>
                                                </div>
                                                <div id="collapse2" class="panel-collapse collapse" aria-expanded="false" role="button">
                                                    <div class="panel-body no-border">
                                                        <p>People always have questions about Services. Hopefully these questions and answers have provided you with all of the information you need to decide</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="panel">
                                                <div class="panel-heading">
                                                    <strong class="panel-title">
                                                        <a class="collapsed" data-toggle="collapse" data-parent="#faq_2848769" href="#collapse4" aria-expanded="false">which Latest technology we used</a>
                                                    </strong>
                                                </div>
                                                <div id="collapse4" class="panel-collapse collapse" aria-expanded="false" role="button">
                                                    <div class="panel-body no-border">
                                                        <p>People always have questions about Services. Hopefully these questions and answers have provided you with all of the information you need to decide</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="row">
                                <!-- section heading -->
                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 mb-40">
                                    <div class="section-heading">
                                        <h3>Latest Press Release</h3>
                                    </div>
                                </div>
                                <!-- section heading -->

                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

                                    <div class="bu-latest-news animated-border-btm">

                                        <figure class="blog-news">
                                            <img src="assets/images/360x133.jpg" alt="" />
                                            <figcaption>
                                                <div>
                                                    <div class="img-holder">
                                                        <div class="bu-date">
                                                            <b>14</b>
                                                            <span class="bu-month">Jan</span>
                                                        </div>
                                                    </div>

                                                    <div class="text-holder">
                                                        <p><a href="#">The Servico is winners of the fourth and sixth annual Industry Awards... </a> </p>
                                                        <span class="bu-sponser">ABC News</span>
                                                    </div>
                                                </div>

                                            </figcaption>
                                        </figure>

                                    </div>
                                    <div class="bu-latest-news animated-border-btm">

                                        <figure class="blog-news">
                                            <img src="assets/images/360x133.jpg" alt="" />
                                            <figcaption>
                                                <div>
                                                    <div class="img-holder">
                                                        <div class="bu-date">
                                                            <b>5</b>
                                                            <span class="bu-month">Dec</span>
                                                        </div>
                                                    </div>

                                                    <div class="text-holder">
                                                        <p><a href="#">We are Leading with latest technology & Equipment in consturction services... </a> </p>
                                                        <span class="bu-sponser">E-Magazine</span>
                                                    </div>
                                                </div>

                                            </figcaption>
                                        </figure>

                                    </div>
                                    <div class="bu-latest-news animated-border-btm">

                                        <figure class="blog-news">
                                            <img src="assets/images/360x133.jpg" alt="" />
                                            <figcaption>
                                                <div>
                                                    <div class="img-holder">
                                                        <div class="bu-date">
                                                            <b>27</b>
                                                            <span class="bu-month">May</span>
                                                        </div>
                                                    </div>

                                                    <div class="text-holder">
                                                        <p><a href="#">Servico wins a contract in the construction of the high-speed... </a> </p>
                                                        <span class="bu-sponser">XYZ News</span>
                                                    </div>
                                                </div>

                                            </figcaption>
                                        </figure>

                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <!-- Section End -->
        <?php } ?>

        <?php if (false) { ?>
            <!-- Call to Action Section -->
            <div class="page-section section-bg-1">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                            <div class="request-qoute">
                                <div class="row">
                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
                                        <div class="text-holer mt-10">
                                            <h3>For Free &amp; Detailed solution: Contact our Experts 24/7</h3>
                                            <!-- <p>Fee free to call us any time, Its our Pleasure : +1 235-888-1214</p>-->
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 text-right">
                                        <a href="#" class="bu-button-simple bu-bgcolor button-swipe btn-3">Contact Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Call to Action Section -->
        <?php } ?>

    </div>

    <?php include '_footer.php'; ?>

</div>
<script src="assets/scripts/menu.js"></script>
<script src="assets/scripts/slick.js"></script>
<script src="assets/scripts/parallax/parallax.js"></script>
<script src="assets/scripts/counter.js"></script>
<script src="assets/scripts/jquery.fitvids.js"></script>
<script src="assets/scripts/ekko-lightbox.js"></script>
<!-- Put all Functions in functions.js -->
<script src="assets/scripts/functions.js"></script>
</body>

</html>