<?php

include 'page01.php';

if (isset($_GET['id'])) {

    $id = $_GET['id'];
    $request = send_sql("SELECT * FROM actu WHERE id = ?", [$id]);
    $actu = $request->fetch(PDO::FETCH_OBJ);

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {

        if ($_FILES['img']['error'] === 0) {

            $tmpName = $_FILES['img']['tmp_name'];
            $imgName = pathinfo($_FILES['img']['name'], PATHINFO_FILENAME) . ".webp";

            $imgName = strtr($imgName, ' ', '-');


            $imgExtension = strtolower(pathinfo($_FILES['img']['name'], PATHINFO_EXTENSION));

            switch ($imgExtension) {
                case 'jpg':
                case 'jpeg':
                    $image = imagecreatefromjpeg($tmpName);
                    break;
                case 'png':
                    $image = imagecreatefrompng($tmpName);
                    break;
                case 'gif':
                    $image = imagecreatefromgif($tmpName);
                    break;
                case 'webp':
                    $image = imagecreatefromwebp($tmpName);
                    break;
                default:
                    die("Format d'image non pris en charge");
            }

            $maxWidth = 1200;
            $maxHeight = 825;

            $width = imagesx($image);
            $height = imagesy($image);

            $rap = $width / $height;

            if ($width > $maxWidth || $height > $maxHeight) {
                $y = min($maxHeight, ($height * $maxWidth / $width));
                $x = $width * $y / $height;
            } else {
                $y = $height;
                $x = $width;
            }


            $img_reduite = imagecreatetruecolor($x, $y);
            imagecopyresampled($img_reduite, $image, 0, 0, 0, 0, $x, $y, $width, $height);
            $destination = "../img/actu/" . $imgName;
            imagewebp($img_reduite, $destination, 70);

            // RECADRAGE DE L'IMAGE (CROP)


            $dimrap = $maxWidth / $maxHeight;
            if ($rap > $dimrap) {
                $newl = round($y * $maxWidth / $maxHeight);
                $newh = $y;
                $x_marge = round(($x - $newl) / 2);
                $y_marge = 0;
            } else {
                $newl = $x;
                $newh = round($x * $maxHeight / $maxWidth);
                $x_marge = 0;
                $y_marge = round(($y - $newh) / 2);
            }

            $finalImage = imagecreatetruecolor($maxWidth, $maxHeight);
            imagecopyresampled($finalImage, $img_reduite, 0, 0, $x_marge, $y_marge, $maxWidth, $maxHeight, $newl, $newh);

            $destination = "../img/actu/mini-" . $imgName;

            imagewebp($finalImage, $destination);

            if (!empty($_POST['afficher'])) {
                $_POST['afficher'] = 1;
            } else {
                $_POST['afficher'] = 0;
            };

            $sql = ('UPDATE actu SET TITRE = ?, AFFICHER = ?, AUTEUR = ?, RESUME=?, TEXTE=?, DATE=?, PHOTO=? WHERE ID = ?');
            try {
                $requete = $db->prepare($sql);
                $params = [
                    $_POST['titre'],
                    $_POST['afficher'],
                    $_POST['auteur'],
                    $_POST['resum'],
                    $_POST['txt'],
                    $_POST['date'],
                    $imgName,
                    $id,
                ];
                $requete->execute($params);
                $messsage = "Succès lors de la modification";

                $request = send_sql("SELECT * FROM actu WHERE ID=?", [$id]);
                $actu = $request->fetch(PDO::FETCH_OBJ);
            } catch (PDOException $e) {
                echo "Erreur lors de le modification de la réalisation: " . $e->getMessage();
                exit();
            }
        } else {

            if (!empty($_POST['afficher'])) {
                $_POST['afficher'] = 1;
            } else {
                $_POST['afficher'] = 0;
            };

            $sql = "UPDATE actu SET AFFICHER = ?, AUTEUR = ?, DATE = ?, TITRE = ?, RESUME = ?, TEXTE = ? WHERE ID = ?";

            try {
                $requete = $db->prepare($sql);
                $params = [
                    $_POST['afficher'],
                    $_POST['auteur'],
                    $_POST['date'],
                    $_POST['titre'],
                    $_POST['resum'],
                    $_POST['txt'],
                    $id
                ];
                $requete->execute($params);

                $messsage = "La mise à jour a été effectuée avec succès.";
                header("Location: actu.php");
            } catch (PDOException $e) {
                echo 'Erreur lors de la mise à jour : ' . $e->getMessage();
                exit();
            }
        }
    }
} else {

    if (!empty($_POST)) {
        if (
            isset($_POST['titre'], $_POST['date'], $_POST['resum'], $_POST['txt'], $_FILES['img'])
            && !empty($_POST['titre'])
            && !empty($_POST['date'])
            && !empty($_POST['resum'])
            && !empty($_POST['txt'])
            && !empty($_FILES['img']['name'])

        ) {
            $dataImg = [
                'img-name' => $_FILES['img']['name'],
                'img-file' => $_FILES['img']['tmp_name']
            ];

            $tmpName = $dataImg['img-file'];
            $imgName = pathinfo($dataImg['img-name'], PATHINFO_FILENAME) . ".webp";

            $imgName = strtr($imgName, ' ', '-');


            $imgExtension = strtolower(pathinfo($dataImg['img-name'], PATHINFO_EXTENSION));

            switch ($imgExtension) {
                case 'jpg':
                case 'jpeg':
                    $image = imagecreatefromjpeg($tmpName);
                    break;
                case 'png':
                    $image = imagecreatefrompng($tmpName);
                    break;
                case 'gif':
                    $image = imagecreatefromgif($tmpName);
                    break;
                case 'webp':
                    $image = imagecreatefromwebp($tmpName);
                    break;
                default:
                    die("Format d'image non pris en charge");
            }

            $maxWidth = 1200;
            $maxHeight = 825;

            $width = imagesx($image);
            $height = imagesy($image);

            $rap = $width / $height;

            if ($width > $maxWidth || $height > $maxHeight) {
                $y = min($maxHeight, ($height * $maxWidth / $width));
                $x = $width * $y / $height;
            } else {
                $y = $height;
                $x = $width;
            }


            $img_reduite = imagecreatetruecolor($x, $y);
            imagecopyresampled($img_reduite, $image, 0, 0, 0, 0, $x, $y, $width, $height);
            $destination = "../img/actu/" . $imgName;
            imagewebp($img_reduite, $destination, 70);

            // RECADRAGE DE L'IMAGE (CROP)


            $dimrap = $maxWidth / $maxHeight;
            if ($rap > $dimrap) {
                $newl = round($y * $maxWidth / $maxHeight);
                $newh = $y;
                $x_marge = round(($x - $newl) / 2);
                $y_marge = 0;
            } else {
                $newl = $x;
                $newh = round($x * $maxHeight / $maxWidth);
                $x_marge = 0;
                $y_marge = round(($y - $newh) / 2);
            }

            $finalImage = imagecreatetruecolor($maxWidth, $maxHeight);
            imagecopyresampled($finalImage, $img_reduite, 0, 0, $x_marge, $y_marge, $maxWidth, $maxHeight, $newl, $newh);

            $destination = "../img/actu/mini-" . $imgName;

            imagewebp($finalImage, $destination);

            if (!empty($_POST['afficher'])) {
                $_POST['afficher'] = 1;
            } else {
                $_POST['afficher'] = 0;
            };

            $sql = "INSERT INTO actu (AFFICHER, AUTEUR, DATE, TITRE, RESUME, TEXTE, PHOTO) VALUES (?, ?, ?, ?, ?, ?, ?)";

            try {
                $res = $db->prepare($sql);
                $params = [
                    $_POST['afficher'],
                    $_POST['auteur'],
                    $_POST['date'],
                    $_POST['titre'],
                    $_POST['resum'],
                    $_POST['txt'],
                    $imgName
            ];
                $res->execute($params);

                header("Location: actu.php?successC");
            } catch (PDOException $e) {
                echo "Erreur lors de la création de la réalisation : " . $e->getMessage();
            }
        } else {
            die("Il manque des informations dans le formulaire.");
        }
    };
}
?>

<p class="titre">Gestion des actualités &nbsp; <a href="actu_fiche.php"><i class="fa fa-plus-square btplus" title="Ajouter un élément"></i></a></p>
<hr width="700" align="left" size="1" style="margin-bottom: 30px">

<?php if (isset($_GET['id'])) { ?>
    <h3>Modifier l'actualité "<?= $actu->TITRE ?>"</h3>
<?php } else { ?>
    <h3>Ajouter une actualité</h3>
<?php }; ?>

<div class="container">
    <div class="row col-lg-8 col-xl-6 px-3 px-md-5 py-5 mx-auto bg-secondary bg-gradient">
        <form class="form-container pt-3" method="POST" enctype="multipart/form-data" action="">
            <div class="pb-1 short-container all-input">
                <label class="col-lg-5" for="titre">Titre :</label>
                <input class="col-lg-7" type="text" id="titre" name="titre" value="<?php if (isset($_GET['id'])) echo $actu->TITRE ?>">
            </div>
            <div class="py-3 short-container all-input">
                <label class="col-lg-5" for="auteur">Auteur :</label>
                <input class="col-lg-7" type="text" id="auteur" name="auteur" value="<?php if (isset($_GET['id']) && !empty($actu->AUTEUR)) echo $actu->AUTEUR ?>">
            </div>
            <div class="py-3 short-container all-input">
                <label class="col-lg-5" for="date">Date :</label>
                <input class="col-lg-7" type="date" id="date" name="date" value="<?php if (isset($_GET['id'])) echo $actu->DATE ?>">
            </div>
            <div class="py-3 long-container all-input">
                <label for="resum">Résumé :</label>
                <textarea name="resum" id="resum" cols="30" rows="5"><?php if (isset($_GET['id'])) echo $actu->RESUME ?></textarea>
            </div>
            <div class="py-3 long-container all-input">
                <label for="txt">Descriptif :</label>
                <textarea name="txt" id="txt" cols="30" rows="5"><?php if (isset($_GET['id'])) echo $actu->TEXTE ?></textarea>
            </div>
            <div class="row all-input">
                <div class="py-3 col">
                    <label for="img">Image :</label>
                    <input type="file" accept=".jpg,.jpeg,.png,.webp.gif" id="img" name="img">
                    <p class="text-white fs-6 fw-lighter">Formats acceptés : <span class="text-decoration-underline">.jpg</span>, <span class="text-decoration-underline">.jpeg</span>, <span class="text-decoration-underline">.png</span>, <span class="text-decoration-underline">.gif</span>, <span class="text-decoration-underline">.webp</span>.</p>
                </div>
                <?php if (isset($_GET['id'])) : ?>
                    <div class=" mt-2 col ">
                        <p class="m-0 p-0">Image actuelle :</p>
                        <div class="img-container pb-3">
                            <span class="mb-2 p-0"><?= $actu->PHOTO ?></span>
                            <img class="current-img" src="../img/actu/mini-<?= $actu->PHOTO ?>" alt="photo_actu">
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="all-input">
                <label for="afficher">Afficher l'actualité : </label>
                <input type="checkbox" id="afficher" name="afficher" value="1" <?php if($actu->AFFICHER == 1) echo "checked" ?>
            </div>
            <div class="pt-3 pb-1 submit-btns">
                <a href="actu.php" class="btn me-10 btn-cancel">Annuler</a>
                <button class="btn btn-primary btn-confirm" type="submit">
                    <?php if (isset($_GET["id"])) : ?>
                        Enregistrer les modifications
                    <?php else : ?>
                        Valider la création
                    <?php endif; ?>
                </button>
            </div>
        </form>
    </div>
</div>